model Engine1b_Param
  import SI = Modelica.SIunits;
  //import GasForce3;
  parameter Real L_cyl = 0.3;
  parameter Real D_piston = 0.1;
  parameter Real delta = 0.01;
  parameter Real L_piston = 0.05;
  parameter Real W_conn = 0.02;
  parameter Real L_crank = 0.5 * (L_cyl - delta - L_piston);
  parameter Real L_conn = 2 * L_crank;
  parameter Real L_max = L_cyl + L_crank;
  Real avg_torque;
  inner Modelica.Mechanics.MultiBody.World world annotation(Placement(visible = true, transformation(origin = {-80.9173,-76.6992}, extent = {{-10,-10},{10,10}}, rotation = 0)));
  Modelica.Mechanics.MultiBody.Joints.Revolute Bearing(useAxisFlange = true, n = {1,0,0}, cylinderLength = 0.02, cylinderDiameter = 0.05) annotation(Placement(visible = true, transformation(origin = {-45.0451,-76.2406}, extent = {{-10,-10},{10,10}}, rotation = 0)));
  Modelica.Mechanics.MultiBody.Parts.BodyCylinder Crank1(diameter = 0.05, r = {0.1,0,0}) annotation(Placement(visible = true, transformation(origin = {-10.5865,-75.7819}, extent = {{-10,-10},{10,10}}, rotation = 0)));
  Modelica.Mechanics.MultiBody.Parts.BodyCylinder Crank3(r = {0.1,0,0}, diameter = 0.03) annotation(Placement(visible = true, transformation(origin = {39.309,-45.4253}, extent = {{-10,-10},{10,10}}, rotation = 0)));
  Modelica.Mechanics.MultiBody.Joints.Revolute B1(n = {1,0,0}, cylinderLength = 0.02, cylinderDiameter = 0.05) annotation(Placement(visible = true, transformation(origin = {39.5634,-6.97548}, extent = {{-10,-10},{10,10}}, rotation = 0)));
  Modelica.Mechanics.MultiBody.Joints.RevolutePlanarLoopConstraint B2(n = {1,0,0}, cylinderLength = 0.02, cylinderDiameter = 0.05) annotation(Placement(visible = true, transformation(origin = {40.8592,24.5155}, extent = {{-10,-10},{10,10}}, rotation = 0)));
  Modelica.Mechanics.MultiBody.Parts.FixedTranslation cylPosition(animation = false, r = {0.15,L_max,0}) annotation(Placement(visible = true, transformation(origin = {-23.5384,90.3437}, extent = {{-10,-10},{10,10}}, rotation = 0)));
  Modelica.Mechanics.MultiBody.Joints.Prismatic Cylinder(useAxisFlange = true, boxWidth = 0.02, n = {0,-1,0}) annotation(Placement(visible = true, transformation(origin = {40.6633,81.7746}, extent = {{-10,10},{10,-10}}, rotation = 270)));
  Modelica.Mechanics.MultiBody.Parts.BodyBox Crank2(height = 0.05, widthDirection = {1,0,0}, width = 0.02, r = {0,L_crank,0}) annotation(Placement(visible = true, transformation(origin = {20.3684,-62.1604}, extent = {{10,-10},{-10,10}}, rotation = 90)));
  Modelica.Mechanics.MultiBody.Parts.BodyBox Crank4(height = 0.05, widthDirection = {1,0,0}, width = 0.02, r = {0,-L_crank,0}) annotation(Placement(visible = true, transformation(origin = {62.2121,-63.6333}, extent = {{-10,10},{10,-10}}, rotation = -90)));
  Modelica.Mechanics.MultiBody.Parts.FixedTranslation Mid(r = {0.05,0,0}) annotation(Placement(visible = true, transformation(origin = {21.0609,-24.2341}, extent = {{10,-10},{-10,10}}, rotation = 90)));
  Modelica.Mechanics.MultiBody.Parts.FixedTranslation Rod1(r = {0,L_conn,0}, animation = false) annotation(Placement(visible = true, transformation(origin = {65.6124,7.07495}, extent = {{10,-10},{-10,10}}, rotation = 90)));
  Modelica.Mechanics.MultiBody.Parts.BodyBox Rod2(widthDirection = {1,0,0}, width = W_conn, height = 0.06, color = {0,0,200}, r = {0,L_conn,0}) annotation(Placement(visible = true, transformation(origin = {90.3839,7.44059}, extent = {{10,-10},{-10,10}}, rotation = 90)));
  Modelica.Mechanics.Rotational.Components.Inertia Inertia(stateSelect = StateSelect.always, J = 0.1, w(fixed = true), phi(fixed = true, start = 0.001, displayUnit = "rad")) annotation(Placement(visible = true, transformation(origin = {-27.9095,-39.8761}, extent = {{10,10},{-10,-10}}, rotation = 180)));
  Modelica.Mechanics.MultiBody.Parts.BodyCylinder Piston(diameter = D_piston, r = {0,-L_piston,0}) annotation(Placement(visible = true, transformation(origin = {84.7428,45.9747}, extent = {{-10,10},{10,-10}}, rotation = 270)));
  Modelica.Mechanics.MultiBody.Parts.FixedTranslation Rod3(r = {0,-L_piston,0}, animation = false) annotation(Placement(visible = true, transformation(origin = {40.4936,51.3664}, extent = {{-10,10},{10,-10}}, rotation = 270)));
  Utilities.GasForce3 gasForce(d = D_piston, L = L_cyl - L_piston, k0 = 0) annotation(Placement(visible = true, transformation(origin = {78.3628,78.9927}, extent = {{-10,10},{10,-10}}, rotation = -90)));
protected
  Real tq_intg(start = 0);
equation
  connect(Rod3.frame_a,Cylinder.frame_b) annotation(Line(points = {{40.4936,61.3664},{40.807,61.3664},{40.807,71.7746},{40.6633,71.7746}}));
  connect(Rod3.frame_a,Piston.frame_a) annotation(Line(points = {{40.4936,61.3664},{83.3638,61.3664},{83.3638,55.9747},{84.7428,55.9747}}));
  connect(B2.frame_a,Rod3.frame_b) annotation(Line(points = {{30.8592,24.5155},{22.6691,24.5155},{22.6691,41.3664},{40.4936,41.3664}}));
  connect(cylPosition.frame_a,world.frame_b) annotation(Line(points = {{-33.5384,90.3437},{-70.8446,90.3437},{-70.8446,-76.6992},{-70.9173,-76.6992}}));
  connect(Cylinder.frame_a,cylPosition.frame_b) annotation(Line(points = {{40.6633,91.7746},{-13.1042,91.7746},{-13.1042,90.3437},{-13.5384,90.3437}}));
  connect(Bearing.axis,Inertia.flange_b) annotation(Line(points = {{-45.0451,-66.2406},{-45.0457,-66.2406},{-45.0457,-39.8761},{-37.9095,-39.8761}}));
  connect(gasForce.flange_b,Cylinder.axis) annotation(Line(points = {{80.9744,71.2779},{46.4351,71.2779},{46.4351,73.7746},{46.6633,73.7746}}));
  connect(gasForce.flange_a,Cylinder.support) annotation(Line(points = {{80.9744,91.2779},{46.8007,91.2779},{46.8007,85.7746},{46.6633,85.7746}}));
  connect(Rod1.frame_b,B2.frame_b) annotation(Line(points = {{65.6124,17.0749},{65.8135,17.0749},{65.8135,24.5155},{50.8592,24.5155}}));
  connect(B1.frame_b,Rod2.frame_a) annotation(Line(points = {{49.5634,-6.97548},{90.6764,-6.97548},{90.6764,-2.55941},{90.3839,-2.55941}}));
  connect(B1.frame_b,Rod1.frame_a) annotation(Line(points = {{49.5634,-6.97548},{65.8135,-6.97548},{65.8135,-2.92505},{65.6124,-2.92505}}));
  connect(Mid.frame_b,B1.frame_a) annotation(Line(points = {{21.0609,-14.2341},{20.841,-14.2341},{20.841,-6.97548},{29.5634,-6.97548}}));
  connect(Mid.frame_a,Crank2.frame_b) annotation(Line(points = {{21.0609,-34.2341},{20.4753,-34.2341},{20.4753,-52.1604},{20.3684,-52.1604}}));
  connect(Crank3.frame_b,Crank4.frame_a) annotation(Line(points = {{49.309,-45.4253},{61.7916,-45.4253},{61.7916,-53.6333},{62.2121,-53.6333}}));
  connect(Crank2.frame_b,Crank3.frame_a) annotation(Line(points = {{20.3684,-52.1604},{20.4753,-52.1604},{20.4753,-45.4253},{29.309,-45.4253}}));
  connect(Crank1.frame_b,Crank2.frame_a) annotation(Line(points = {{-0.586472,-75.7819},{20.841,-75.7819},{20.841,-72.1604},{20.3684,-72.1604}}));
  connect(Bearing.frame_b,Crank1.frame_a) annotation(Line(points = {{-35.0451,-76.2406},{-20.1097,-76.2406},{-20.1097,-75.7819},{-20.5865,-75.7819}}));
  connect(world.frame_b,Bearing.frame_a) annotation(Line(points = {{-70.9173,-76.6992},{-55.2102,-76.6992},{-55.2102,-76.2406},{-55.0451,-76.2406}}));
  der(tq_intg) = Inertia.flange_b.tau;
  avg_torque = tq_intg / time;
end Engine1b_Param;

